;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; "Smileymation"
; 
; by jmin/F4CG
;
; gfx......4gentE
; sid......Argon
; code.....jmin
; 
; released 2024-10-25
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;
; load .sid

* = $1000
!bin  "Got_the_Time.sid",,$7e

;;;;;;;;;;;;;;;;
; BASIC start address (#2049)

* = $0801          
!byte $0C, $08, $00, $00, $9E, $32, $30, $36
!byte $31, $00, $00, $00

;;;;;;;;;;;;;;;;
; check if PAL or NTSC
; (from codebase64)

l1:
    lda $d012
l2:
    cmp $d012
    beq l2
    bmi l1
    cmp #$20
    bcc ntsc
l3:
    lda #$15
    sta $d018
    jmp main
    
ntsc:
    lda #7
    sta palNtsc
    jmp l3

;;;;;;;;;;;;;;;;
; timing flag

timingFlag:
!byte 5

;;;;;;;;;;;;;;;;
; gradients for color cycling

ccycle01:
!byte 00,06,11,04,12,05,15,13,15,05,12,04,11,06,00
!byte 00,06,11,04,12,05,15,13,15,05,12,04,11,06,00

ccycle02:
!byte 15,10,12,08,11,02,09,00,00,09,02,11,08,12,10
!byte 15,10,12,08,11,02,09,00,00,09,02,11,08,12,10

ccycle04:                        

!byte 00,06,11,04,12,05,15,13,15,05,12,04,11,06,00,00,00,00,09,02,11,08,12,10,15,10,12,08,11,02,09,00,00,00
!byte 00,06,11,04,12,05,15,13,15,05,12,04,11,06,00,00,00,00,09,02,11,08,12,10,15,10,12,08,11,02,09,00,00,00

;;;;;;;;;;;;;;;;
; counter patterns

patternCounter01:
!byte 0
patternCounter02:
!byte 0
patternCounter03:
!byte 0
patternCounter04:
!byte 0

;;;;;;;;;;;;;;;;
; counter frame

colorframe:
!byte 0

;;;;;;;;;;;;;;;;
; PAL/NTSC: 0=pal, >0 is NTSC 

palNtsc:
!byte 0

;;;;;;;;;;;;;;;;
; wait duration

waitduration:
!byte 08

main: 
    ; set border and BG
    lda #$00
    sta $d020
    sta $d021
    
    ; draw full PETSCII for color cycling
    ldx #$00
    jsr drawPETSCII
    ldx #$00
    jsr drawColor
    
    
    lda #$fa
    sta timingFlag     ; update timing flag (leftover from another project)
    
    ; start of intro anmiation
    ldx #$64
    stx waitduration
    jsr wait
    
    
    jsr eyesClosed
    
    ldx #$0c
    stx waitduration
    jsr wait
    
    jsr eyesOpen
    
    ldx #$0c
    stx waitduration
    jsr wait
    
    jsr eyesClosed
    
    ldx #$0c
    stx waitduration
    jsr wait
    
    jsr eyesOpen
    
    ldx #$05
    stx waitduration
    jsr wait
    
    ; init music
    lda #$00
    jsr $1000
    
    jsr eyesLU
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    
    jsr loopPattern01
    jsr resetLoop
    
    jsr eyesRU
    jsr loopPattern01
    jsr resetLoop
    
    jsr eyesClosed
    jsr loopPattern01
    jsr resetLoop
    
    jsr eyesRU
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop    
    
    jsr eyesOpen
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    
    jsr eyesClosed
    jsr loopPattern01
    jsr resetLoop    
    
    jsr eyesOpen
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    
    ldx #$00
    jsr drawColor
    ; end of intro anmiation
    
mainloop:
    jsr eyesLD
    jsr loopPattern02
    jsr resetLoop
    jsr loopPattern02
    jsr resetLoop
    jsr loopPattern02
    jsr resetLoop
    jsr eyesClosed
    jsr loopPattern02
    jsr resetLoop
    jsr eyesRD
    jsr loopPattern02
    jsr resetLoop
    jsr loopPattern02
    jsr resetLoop
    jsr loopPattern02
    jsr resetLoop
    jsr loopPattern02
    jsr resetLoop
    jsr eyesOpen
    
    jsr clearColor    
    
    jsr loopPattern03
    jsr resetLoop
    jsr eyesLU
    jsr loopPattern03
    jsr resetLoop
    jsr eyesRU
    jsr loopPattern03
    jsr resetLoop
    jsr loopPattern03
    jsr resetLoop
    jsr loopPattern03
    jsr resetLoop
    jsr eyesLD
    jsr loopPattern03
    jsr resetLoop
    jsr eyesOpen
    jsr loopPattern03
    jsr resetLoop
    jsr loopPattern03
    jsr resetLoop
    jsr loopPattern03
    jsr resetLoop
    jsr eyesClosed
    jsr loopPattern03
    jsr resetLoop
    jsr eyesOpen
    
    jsr clearColor    
    
    jsr loopPattern04
    jsr resetLoop
    
    jsr eyesInsane
    jsr loopPattern05
    jsr resetLoop
    
    jsr eyesInsane
    jsr loopPattern06
    jsr resetLoop    
    
    jsr clearColor
    
    jsr eyesClosed
    
    ldx #$09
    stx waitduration
    jsr wait
    
    jsr eyesInsane
    
    ldx #$09
    stx waitduration
    jsr wait
    
    jsr eyesClosed
    
    ldx #$09
    stx waitduration
    jsr wait
    
    jsr eyesInsane
    
    ldx #$09
    stx waitduration
    jsr wait
    
    jsr eyesClosed
    
    ldx #$09
    stx waitduration
    jsr wait
    
    jsr eyesOpen
    
    ldx #$09
    stx waitduration
    jsr wait
    
    jsr eyesClosed
    
    ldx #$09
    stx waitduration
    jsr wait
    
    jsr eyesOpen
    
    ldx #$09
    stx waitduration
    jsr wait
    
    jsr eyesClosed
    
    ldx #$09
    stx waitduration
    jsr wait
    
    jsr eyesOpen
    
    ldx #$1a
    stx waitduration
    jsr wait
    
    jsr clearColor
    
    jsr eyesLU
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    
    jsr loopPattern01
    jsr resetLoop
    jsr eyesRU
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    jsr eyesRU
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop    
    
    jsr eyesOpen
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    
    jsr eyesClosed
    
    jsr loopPattern01
    jsr resetLoop    
    
    jsr eyesOpen
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    jsr loopPattern01
    jsr resetLoop
    
    jsr clearColor
    
    jmp mainloop

;;;;;;;;;;;;;;;;
; Loop patterns
    
loopPattern01:
    jsr singlewait
    jsr ccycle
    lda patternCounter01
    cmp #$01
    bne loopPattern01
    rts    

loopPattern02:
    jsr singlewait
    jsr ccycle_02
    lda patternCounter02
    cmp #$01
    bne loopPattern02
    rts

loopPattern03:
    jsr ccycle
    ldx colorframe
    dex 
    stx colorframe
    jsr ccycle_02
    lda patternCounter01
    cmp #$01
    bne loopPattern03
    rts

loopPattern04:
    jsr singlewait
    jsr singlewait
    jsr ccycle_04
    lda patternCounter04
    cmp #$02
    bne loopPattern04
    rts
    
loopPattern05:
    jsr singlewait
    jsr ccycle_04
    lda patternCounter04
    cmp #$03
    bne loopPattern05
    rts
    
loopPattern06:
    jsr ccycle_04
    lda patternCounter04
    cmp #$04
    bne loopPattern06
    rts

;;;;;;;;;;;;;;;;
; reset loop parameters

resetLoop:
    lda #0
    sta patternCounter01
    sta patternCounter02
    sta patternCounter03
    sta patternCounter04
    sta colorframe
    
    rts    
    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; fills the screen with a color given in a

clearColor:
    ldx #$00
clearColorLoop:
    lda #$0b
    sta $d800,x
    sta $d8fa,x
    sta $d9f4,x
    sta $daee,x
    inx
    cpx #$fa
    bne clearColorLoop
    
; color in the center line of smilies in shades of grey

    ; slice 1
    lda #01     ; color
    
    sta $d979
    sta $d97a
    sta $d97b
    sta $d97c
    sta $d97d
    sta $d9a0
    sta $d9a1
    sta $d9a2
    sta $d9a3
    sta $d9a4
    sta $d9a5
    sta $d9a6
    sta $d9c9
    sta $d9ca
    sta $d9cb
    sta $d9cc
    sta $d9cd
    sta $d9f0
    sta $d9f1
    sta $d9f2
    sta $d9f3
    sta $d9f4
    sta $d9f5
    sta $d9f6
    sta $da18
    sta $da19
    sta $da1a
    sta $da1b
    sta $da1c
    sta $da1d
    sta $da1e
    sta $da40
    sta $da41
    sta $da42
    sta $da43
    sta $da44
    sta $da45
    sta $da46
    sta $da69
    sta $da6a
    sta $da6b
    sta $da6c
    sta $da6d
    
    ; slice 2
    lda #$0f    ; color

    sta $d9ce
    sta $d9c8    
    sta $d974
    sta $d975
    sta $d976
    sta $d977
    sta $d978
    sta $d97e
    sta $d97f
    sta $d980
    sta $d981
    sta $d982
    sta $d99b
    sta $d99c
    sta $d99d
    sta $d99e
    sta $d99f
    sta $d9a7
    sta $d9a8
    sta $d9a9
    sta $d9aa
    sta $d9ab
    sta $d9c3
    sta $d9c4
    sta $d9c5
    sta $d9c6
    sta $d9c7
    sta $d9cf
    sta $d9d0
    sta $d9d1
    sta $d9d2
    sta $d9d3
    sta $d9eb
    sta $d9ec
    sta $d9ed
    sta $d9ee
    sta $d9ef
    sta $d9f7
    sta $d9f8
    sta $d9f9
    sta $d9fa
    sta $d9fb
    sta $da13
    sta $da14
    sta $da15
    sta $da16
    sta $da17
    sta $da1f
    sta $da20
    sta $da21
    sta $da22
    sta $da23
    sta $da3b
    sta $da3c
    sta $da3d
    sta $da3e
    sta $da3f
    sta $da47
    sta $da48
    sta $da49
    sta $da4a
    sta $da4b
    sta $da64
    sta $da65
    sta $da66
    sta $da67
    sta $da68
    sta $da6e
    sta $da6f
    sta $da70
    sta $da71
    sta $da72

    ; slice 3
    lda #$0c    ; color
    
    sta $d96d
    sta $d96e
    sta $d96f
    sta $d970
    sta $d971
    sta $d972
    sta $d973
    sta $d983
    sta $d984
    sta $d985
    sta $d986
    sta $d987
    sta $d988
    sta $d989
    sta $d994
    sta $d995
    sta $d996
    sta $d997
    sta $d998
    sta $d999
    sta $d99a
    sta $d9ac
    sta $d9ad
    sta $d9ae
    sta $d9af
    sta $d9b0
    sta $d9b1
    sta $d9b2
    sta $d9bc
    sta $d9bd
    sta $d9be
    sta $d9bf
    sta $d9c0
    sta $d9c1
    sta $d9c2
    sta $d9d4
    sta $d9d5
    sta $d9d6
    sta $d9d7
    sta $d9d8
    sta $d9d9
    sta $d9da
    sta $d9e4
    sta $d9e5
    sta $d9e6
    sta $d9e7
    sta $d9e8
    sta $d9e9
    sta $d9ea
    sta $d9fc
    sta $d9fd
    sta $d9fe
    sta $d9ff
    sta $da00
    sta $da01
    sta $da02
    sta $da0c
    sta $da0d
    sta $da0e
    sta $da0f
    sta $da10
    sta $da11
    sta $da12
    sta $da24
    sta $da25
    sta $da26
    sta $da27
    sta $da28
    sta $da29
    sta $da2a
    sta $da34
    sta $da35
    sta $da36
    sta $da37
    sta $da38
    sta $da39
    sta $da3a
    sta $da4c
    sta $da4d
    sta $da4e
    sta $da4f
    sta $da50
    sta $da51
    sta $da52
    sta $da5d
    sta $da5e
    sta $da5f
    sta $da60
    sta $da61
    sta $da62
    sta $da63
    sta $da73
    sta $da74
    sta $da75
    sta $da76
    sta $da77
    sta $da78
    sta $da79

    ; slice 4
    lda #$0b    ; color

    sta $d96b
    sta $d96c
    sta $d98a
    sta $d98b
    sta $d992
    sta $d993
    sta $d9b3
    sta $d9b4
    sta $d9ba
    sta $d9bb
    sta $d9db
    sta $d9dc
    sta $d9e2
    sta $d9e3
    sta $da03
    sta $da04
    sta $da0a
    sta $da0b
    sta $da2b
    sta $da2c
    sta $da32
    sta $da33
    sta $da53
    sta $da54
    sta $da5b
    sta $da5c
    sta $da7a
    sta $da7b
    
    rts
    

;;;;;;;;;;;;;;;;;;;;;;
; drawing eyes

eyesOpen:
  lda #$d1
  sta $05CA
  sta $05CC
  rts
  
eyesClosed:
  lda #$ad
  sta $05CA
  sta $05CC
  rts
  
eyesInsane:
  lda #$d7
  sta $05CA
  sta $05CC 
  rts    

eyesLU:
  lda #$7a
  sta $05CA
  sta $05CC 
  rts    
  
eyesRU:
  lda #$4c
  sta $05CA
  sta $05CC 
  rts    
  
eyesLD:
  lda #$50
  sta $05CA
  sta $05CC 
  rts    
  
eyesRD:
  lda #$4f
  sta $05CA
  sta $05CC 
  rts    
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sync to frame

singlewait:
    ldx #$01
    stx waitduration
wait:
    lda timingFlag
    cmp $d012
    bne wait
    lda $d012
wait_nextLine:  
    cmp $d012
    beq wait_nextLine
    jsr music
    ldx waitduration
    dex
    stx waitduration
    cpx #$00
    bne wait
    rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sync music

music:
    ldx palNtsc
    cpx #$00
    beq playmusic
    dex
    stx palNtsc
    cpx #$00
    bne playmusic
    ldx #$07
    stx palNtsc
    rts
playmusic:
    jsr $1003 ; play the music
    rts
    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; draw complete PETSCII pic (4x 250 char bytes)

drawPETSCII:
    lda petscii_01,x
    sta $0400,x
    lda petscii_01+$0fa,x
    sta $04fa,x
    lda petscii_01+$1f4,x
    sta $05f4,x
    lda petscii_01+$2ee,x
    sta $06ee,x
    inx
    cpx #$fa
    bne drawPETSCII
    rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; draw complete color pic (4x 250 color bytes)

drawColor:
    lda color_01,x
    sta $d800,x
    lda color_01+$0fa,x
    sta $d8fa,x
    lda color_01+$1f4,x
    sta $d9f4,x
    lda color_01+$2ee,x
    sta $daee,x
    inx
    cpx #$fa
    bne drawColor
    rts    

*=$19c8
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; draw colors of CC pattern 01

ccycle:
    ldx colorframe
    
    ;slice01
    lda ccycle01,x
    
    sta $d803
    sta $d804
    sta $d822
    sta $d823
    sta $d82a
    sta $d82b
    sta $d84b
    sta $d84c
    sta $d852
    sta $d853
    sta $d854
    sta $d872
    sta $d873
    sta $d874
    sta $d87a
    sta $d87b
    sta $d89b
    sta $d89c
    sta $d8a2
    sta $d8a3
    sta $d8c3
    sta $d8c4
    sta $d8ca
    sta $d8cb
    sta $d8cc
    sta $d8ea
    sta $d8eb
    sta $d8ec
    sta $d8f2
    sta $d8f3
    sta $d913
    sta $d914
    sta $d91a
    sta $d91b
    sta $d93b
    sta $d93c
    sta $d942
    sta $d943
    sta $d963
    sta $d964
    sta $d96a
    sta $d98c    

    ;slice02
    inx
    lda ccycle01,x

    sta $d805
    sta $d806
    sta $d807
    sta $d81f
    sta $d820
    sta $d821
    sta $d82d
    sta $d82e
    sta $d848
    sta $d849
    sta $d855
    sta $d856
    sta $d857
    sta $d86f
    sta $d870
    sta $d871
    sta $d87c
    sta $d87d
    sta $d87e
    sta $d898
    sta $d899
    sta $d89a
    sta $d8a4
    sta $d8a5
    sta $d8a6
    sta $d8c0
    sta $d8c1
    sta $d8c2
    sta $d8cd
    sta $d8ce
    sta $d8cf
    sta $d8e7
    sta $d8e8
    sta $d8e9
    sta $d8f4
    sta $d8f5
    sta $d8f6
    sta $d910
    sta $d911
    sta $d912
    sta $d91c
    sta $d91d
    sta $d91e
    sta $d938
    sta $d939
    sta $d93a
    sta $d944
    sta $d945
    sta $d946
    sta $d960
    sta $d961
    sta $d962

    ;slice03
    inx
    lda ccycle01,x
        
    sta $d808
    sta $d809
    sta $d80a
    sta $d80b
    sta $d81b
    sta $d81c
    sta $d81d
    sta $d81e
    sta $d830
    sta $d831
    sta $d832
    sta $d844
    sta $d845
    sta $d846
    sta $d858
    sta $d859
    sta $d85a
    sta $d85b
    sta $d86b
    sta $d86c
    sta $d86d
    sta $d86e
    sta $d87f
    sta $d880
    sta $d881
    sta $d882
    sta $d894
    sta $d895
    sta $d896
    sta $d897
    sta $d8a7
    sta $d8a8
    sta $d8a9
    sta $d8aa
    sta $d8bc
    sta $d8bd
    sta $d8be
    sta $d8bf
    sta $d8d0
    sta $d8d1
    sta $d8d2
    sta $d8d3
    sta $d8e3
    sta $d8e4
    sta $d8e5
    sta $d8e6
    sta $d8f7
    sta $d8f8
    sta $d8f9
    sta $d8fa
    sta $d90c
    sta $d90d
    sta $d90e
    sta $d90f
    sta $d91f
    sta $d920
    sta $d921
    sta $d922
    sta $d934
    sta $d935
    sta $d936
    sta $d937
    sta $d947
    sta $d948
    sta $d949
    sta $d94a
    sta $d95c
    sta $d95d
    sta $d95e
    sta $d95f

    ;slice04
    inx
    lda ccycle01,x

    sta $d80c
    sta $d80d
    sta $d80e
    sta $d80f
    sta $d810
    sta $d816
    sta $d817
    sta $d818
    sta $d819
    sta $d81a
    sta $d833
    sta $d834
    sta $d835
    sta $d836
    sta $d837
    sta $d83f
    sta $d840
    sta $d841
    sta $d842
    sta $d843
    sta $d85c
    sta $d85d
    sta $d85e
    sta $d85f
    sta $d860
    sta $d866
    sta $d867
    sta $d868
    sta $d869
    sta $d86a
    sta $d883
    sta $d884
    sta $d885
    sta $d886
    sta $d887
    sta $d88f
    sta $d890
    sta $d891
    sta $d892
    sta $d893
    sta $d8ab
    sta $d8ac
    sta $d8ad
    sta $d8ae
    sta $d8af
    sta $d8b7
    sta $d8b8
    sta $d8b9
    sta $d8ba
    sta $d8bb
    sta $d8d4
    sta $d8d5
    sta $d8d6
    sta $d8d7
    sta $d8d8
    sta $d8de
    sta $d8df
    sta $d8e0
    sta $d8e1
    sta $d8e2
    sta $d8fb
    sta $d8fc
    sta $d8fd
    sta $d8fe
    sta $d8ff
    sta $d907
    sta $d908
    sta $d909
    sta $d90a
    sta $d90b
    sta $d923
    sta $d924
    sta $d925
    sta $d926
    sta $d927
    sta $d92f
    sta $d930
    sta $d931
    sta $d932
    sta $d933
    sta $d94b
    sta $d94c
    sta $d94d
    sta $d94e
    sta $d94f
    sta $d957
    sta $d958
    sta $d959
    sta $d95a
    sta $d95b

    ;slice05
    inx
    lda ccycle01,x
    
    sta $d811
    sta $d812
    sta $d813
    sta $d814
    sta $d815
    sta $d838
    sta $d839
    sta $d83a
    sta $d83b
    sta $d83c
    sta $d83d
    sta $d83e
    sta $d861
    sta $d862
    sta $d863
    sta $d864
    sta $d865
    sta $d888
    sta $d889
    sta $d88a
    sta $d88b
    sta $d88c
    sta $d88d
    sta $d88e
    sta $d8b0
    sta $d8b1
    sta $d8b2
    sta $d8b3
    sta $d8b4
    sta $d8b5
    sta $d8b6
    sta $d8d9
    sta $d8da
    sta $d8db
    sta $d8dc
    sta $d8dd
    sta $d900
    sta $d901
    sta $d902
    sta $d903
    sta $d904
    sta $d905
    sta $d906
    sta $d928
    sta $d929
    sta $d92a
    sta $d92b
    sta $d92c
    sta $d92d
    sta $d92e
    sta $d950
    sta $d951
    sta $d952
    sta $d953
    sta $d954
    sta $d955
    sta $d956
    
    ;check gradient
    ldx colorframe
    cpx #$0f
    bne contPattern01
    ldy patternCounter01
    iny
    sty patternCounter01
    ldx #$ff
contPattern01:
    inx 
    stx colorframe
    jsr singlewait
    rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; draw colors of CC pattern 02

ccycle_02:

    ;slice01
    ldx colorframe
    lda ccycle02,x
    
    sta $da5a
    sta $da7c
    sta $da82
    sta $da83
    sta $daa3
    sta $daa4
    sta $daaa
    sta $daab
    sta $dacb
    sta $dacc
    sta $dad2
    sta $dad3
    sta $daf3
    sta $daf4
    sta $dafa
    sta $dafb
    sta $dafc
    sta $db1a
    sta $db1b
    sta $db1c
    sta $db22
    sta $db23
    sta $db43
    sta $db44
    sta $db4a
    sta $db4b
    sta $db6b
    sta $db6c
    sta $db72
    sta $db73
    sta $db74
    sta $db92
    sta $db93
    sta $db94
    sta $db9a
    sta $db9b
    sta $dbbb
    sta $dbbc
    sta $dbc3
    sta $dbc4
    sta $dbe2
    sta $dbe3

    ;slice02
    inx
    lda ccycle02,x
    
    sta $da84
    sta $da85
    sta $da86
    sta $daa0
    sta $daa1
    sta $daa2
    sta $daac
    sta $daad
    sta $daae
    sta $dac8
    sta $dac9
    sta $daca
    sta $dad4
    sta $dad5
    sta $dad6
    sta $daf0
    sta $daf1
    sta $daf2
    sta $dafd
    sta $dafe
    sta $daff
    sta $db17
    sta $db18
    sta $db19
    sta $db24
    sta $db25
    sta $db26
    sta $db40
    sta $db41
    sta $db42
    sta $db4c
    sta $db4d
    sta $db4e
    sta $db68
    sta $db69
    sta $db6a
    sta $db75
    sta $db76
    sta $db77
    sta $db8f
    sta $db90
    sta $db91
    sta $db9d
    sta $db9e
    sta $dbb8
    sta $dbb9
    sta $dbc5
    sta $dbc6
    sta $dbc7
    sta $dbdf
    sta $dbe0
    sta $dbe1
    
    ;slice03
    inx
    lda ccycle02,x

    sta $da87
    sta $da88
    sta $da89
    sta $da8a
    sta $da9c
    sta $da9d
    sta $da9e
    sta $da9f
    sta $daaf
    sta $dab0
    sta $dab1
    sta $dab2
    sta $dac4
    sta $dac5
    sta $dac6
    sta $dac7
    sta $dad7
    sta $dad8
    sta $dad9
    sta $dada
    sta $daec
    sta $daed
    sta $daee
    sta $daef
    sta $db00
    sta $db01
    sta $db02
    sta $db03
    sta $db13
    sta $db14
    sta $db15
    sta $db16
    sta $db27
    sta $db28
    sta $db29
    sta $db2a
    sta $db3c
    sta $db3d
    sta $db3e
    sta $db3f
    sta $db4f
    sta $db50
    sta $db51
    sta $db52
    sta $db64
    sta $db65
    sta $db66
    sta $db67
    sta $db78
    sta $db79
    sta $db7a
    sta $db7b
    sta $db8b
    sta $db8c
    sta $db8d
    sta $db8e
    sta $dba0
    sta $dba1
    sta $dba2
    sta $dbb4
    sta $dbb5
    sta $dbb6
    sta $dbc8
    sta $dbc9
    sta $dbca
    sta $dbcb
    sta $dbdb
    sta $dbdc
    sta $dbdd
    sta $dbde

    ;slice04
    inx
    lda ccycle02,x

    sta $da8b
    sta $da8c
    sta $da8d
    sta $da8e
    sta $da8f
    sta $da97
    sta $da98
    sta $da99
    sta $da9a
    sta $da9b
    sta $dab3
    sta $dab4
    sta $dab5
    sta $dab6
    sta $dab7
    sta $dabf
    sta $dac0
    sta $dac1
    sta $dac2
    sta $dac3
    sta $dadb
    sta $dadc
    sta $dadd
    sta $dade
    sta $dadf
    sta $dae7
    sta $dae8
    sta $dae9
    sta $daea
    sta $daeb
    sta $db04
    sta $db05
    sta $db06
    sta $db07
    sta $db08
    sta $db0e
    sta $db0f
    sta $db10
    sta $db11
    sta $db12
    sta $db2b
    sta $db2c
    sta $db2d
    sta $db2e
    sta $db2f
    sta $db37
    sta $db38
    sta $db39
    sta $db3a
    sta $db3b
    sta $db53
    sta $db54
    sta $db55
    sta $db56
    sta $db57
    sta $db5f
    sta $db60
    sta $db61
    sta $db62
    sta $db63
    sta $db7c
    sta $db7d
    sta $db7e
    sta $db7f
    sta $db80
    sta $db86
    sta $db87
    sta $db88
    sta $db89
    sta $db8a
    sta $dba3
    sta $dba4
    sta $dba5
    sta $dba6
    sta $dba7
    sta $dbaf
    sta $dbb0
    sta $dbb1
    sta $dbb2
    sta $dbb3
    sta $dbcc
    sta $dbcd
    sta $dbce
    sta $dbcf
    sta $dbd0
    sta $dbd6
    sta $dbd7
    sta $dbd8
    sta $dbd9
    sta $dbda

    ;slice05
    inx
    lda ccycle02,x

    sta $da90
    sta $da91
    sta $da92
    sta $da93
    sta $da94
    sta $da95
    sta $da96
    sta $dab8
    sta $dab9
    sta $daba
    sta $dabb
    sta $dabc
    sta $dabd
    sta $dabe
    sta $dae0
    sta $dae1
    sta $dae2
    sta $dae3
    sta $dae4
    sta $dae5
    sta $dae6
    sta $db09
    sta $db0a
    sta $db0b
    sta $db0c
    sta $db0d
    sta $db30
    sta $db31
    sta $db32
    sta $db33
    sta $db34
    sta $db35
    sta $db36
    sta $db58
    sta $db59
    sta $db5a
    sta $db5b
    sta $db5c
    sta $db5d
    sta $db5e
    sta $db81
    sta $db82
    sta $db83
    sta $db84
    sta $db85
    sta $dba8
    sta $dba9
    sta $dbaa
    sta $dbab
    sta $dbac
    sta $dbad
    sta $dbae
    sta $dbd1
    sta $dbd2
    sta $dbd3
    sta $dbd4
    sta $dbd5
    
    ;check gradient
    ldx colorframe
    cpx #$0f
    bne contPattern02
    ldy patternCounter02
    iny
    sty patternCounter02
    ldx #$ff
contPattern02:
    inx 
    stx colorframe
    jsr singlewait
    rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; draw colors of CC pattern 04

ccycle_04:
    ldx colorframe
    lda ccycle04,x
    ;slice01

    sta $d803
    sta $d804
    sta $d822
    sta $d823
    sta $d82a
    sta $d82b
    sta $d84b
    sta $d84c
    sta $d852
    sta $d874
    sta $db72
    sta $db94
    sta $db9a
    sta $db9b
    sta $dbbb
    sta $dbbc
    sta $dbc3
    sta $dbc4
    sta $dbe2
    sta $dbe3

    ;slice02
    inx
    lda ccycle04,x

    sta $d805
    sta $d806
    sta $d807
    sta $d81f
    sta $d820
    sta $d821
    sta $d82d
    sta $d82e
    sta $d848
    sta $d849
    sta $d853
    sta $d854
    sta $d872
    sta $d873
    sta $d87a
    sta $d87b
    sta $d89b
    sta $d89c
    sta $d8a2
    sta $d8a3
    sta $d8c3
    sta $d8c4
    sta $d8ca
    sta $d8ec
    sta $dafa
    sta $db1c
    sta $db22
    sta $db23
    sta $db43
    sta $db44
    sta $db4a
    sta $db4b
    sta $db6b
    sta $db6c
    sta $db73
    sta $db74
    sta $db92
    sta $db93
    sta $db9d
    sta $db9e
    sta $dbb8
    sta $dbb9
    sta $dbc5
    sta $dbc6
    sta $dbc7
    sta $dbdf
    sta $dbe0
    sta $dbe1

    ;slice03
    inx
    lda ccycle04,x

    sta $d808
    sta $d809
    sta $d80a
    sta $d80b
    sta $d81b
    sta $d81c
    sta $d81d
    sta $d81e
    sta $d830
    sta $d831
    sta $d832
    sta $d844
    sta $d845
    sta $d846
    sta $d855
    sta $d856
    sta $d857
    sta $d86f
    sta $d870
    sta $d871
    sta $d87c
    sta $d87d
    sta $d87e
    sta $d898
    sta $d899
    sta $d89a
    sta $d8a4
    sta $d8a5
    sta $d8a6
    sta $d8c0
    sta $d8c1
    sta $d8c2
    sta $d8cb
    sta $d8cc
    sta $d8ea
    sta $d8eb
    sta $d8f2
    sta $d8f3
    sta $d913
    sta $d914
    sta $d91a
    sta $d91b
    sta $d93b
    sta $d93c
    sta $d942
    sta $d943
    sta $d963
    sta $d964
    sta $d96a
    sta $d98c
    sta $da5a
    sta $da7c
    sta $da82
    sta $da83
    sta $daa3
    sta $daa4
    sta $daaa
    sta $daab
    sta $dacb
    sta $dacc
    sta $dad2
    sta $dad3
    sta $daf3
    sta $daf4
    sta $dafb
    sta $dafc
    sta $db1a
    sta $db1b
    sta $db24
    sta $db25
    sta $db26
    sta $db40
    sta $db41
    sta $db42
    sta $db4c
    sta $db4d
    sta $db4e
    sta $db68
    sta $db69
    sta $db6a
    sta $db75
    sta $db76
    sta $db77
    sta $db8f
    sta $db90
    sta $db91
    sta $dba0
    sta $dba1
    sta $dba2
    sta $dbb4
    sta $dbb5
    sta $dbb6
    sta $dbc8
    sta $dbc9
    sta $dbca
    sta $dbcb
    sta $dbdb
    sta $dbdc
    sta $dbdd
    sta $dbde

    ;slice04
    inx
    lda ccycle04,x

    sta $d80c
    sta $d80d
    sta $d80e
    sta $d80f
    sta $d810
    sta $d816
    sta $d817
    sta $d818
    sta $d819
    sta $d81a
    sta $d833
    sta $d834
    sta $d835
    sta $d836
    sta $d837
    sta $d83f
    sta $d840
    sta $d841
    sta $d842
    sta $d843
    sta $d858
    sta $d859
    sta $d85a
    sta $d85b
    sta $d86b
    sta $d86c
    sta $d86d
    sta $d86e
    sta $d87f
    sta $d880
    sta $d881
    sta $d882
    sta $d894
    sta $d895
    sta $d896
    sta $d897
    sta $d8a7
    sta $d8a8
    sta $d8a9
    sta $d8aa
    sta $d8bc
    sta $d8bd
    sta $d8be
    sta $d8bf
    sta $d8cd
    sta $d8ce
    sta $d8cf
    sta $d8e7
    sta $d8e8
    sta $d8e9
    sta $d8f4
    sta $d8f5
    sta $d8f6
    sta $d910
    sta $d911
    sta $d912
    sta $d91c
    sta $d91d
    sta $d91e
    sta $d938
    sta $d939
    sta $d93a
    sta $d944
    sta $d945
    sta $d946
    sta $d960
    sta $d961
    sta $d962
    sta $d96b
    sta $d96c
    sta $d98a
    sta $d98b
    sta $d992
    sta $d993
    sta $d9b3
    sta $d9b4
    sta $d9ba
    sta $d9bb
    sta $d9db
    sta $d9dc
    sta $d9e2
    sta $d9e3
    sta $da03
    sta $da04
    sta $da0a
    sta $da0b
    sta $da2b
    sta $da2c
    sta $da32
    sta $da33
    sta $da53
    sta $da54
    sta $da5b
    sta $da5c
    sta $da7a
    sta $da7b
    sta $da84
    sta $da85
    sta $da86
    sta $daa0
    sta $daa1
    sta $daa2
    sta $daac
    sta $daad
    sta $daae
    sta $dac8
    sta $dac9
    sta $daca
    sta $dad4
    sta $dad5
    sta $dad6
    sta $daf0
    sta $daf1
    sta $daf2
    sta $dafd
    sta $dafe
    sta $daff
    sta $db17
    sta $db18
    sta $db19
    sta $db27
    sta $db28
    sta $db29
    sta $db2a
    sta $db3c
    sta $db3d
    sta $db3e
    sta $db3f
    sta $db4f
    sta $db50
    sta $db51
    sta $db52
    sta $db64
    sta $db65
    sta $db66
    sta $db67
    sta $db78
    sta $db79
    sta $db7a
    sta $db7b
    sta $db8b
    sta $db8c
    sta $db8d
    sta $db8e
    sta $dba3
    sta $dba4
    sta $dba5
    sta $dba6
    sta $dba7
    sta $dbaf
    sta $dbb0
    sta $dbb1
    sta $dbb2
    sta $dbb3
    sta $dbcc
    sta $dbcd
    sta $dbce
    sta $dbcf
    sta $dbd0
    sta $dbd6
    sta $dbd7
    sta $dbd8
    sta $dbd9
    sta $dbda

    ;slice05
    inx
    lda ccycle04,x

    sta $d811
    sta $d812
    sta $d813
    sta $d814
    sta $d815
    sta $d838
    sta $d839
    sta $d83a
    sta $d83b
    sta $d83c
    sta $d83d
    sta $d83e
    sta $d85c
    sta $d85d
    sta $d85e
    sta $d85f
    sta $d860
    sta $d866
    sta $d867
    sta $d868
    sta $d869
    sta $d86a
    sta $d883
    sta $d884
    sta $d885
    sta $d886
    sta $d887
    sta $d88f
    sta $d890
    sta $d891
    sta $d892
    sta $d893
    sta $d8ab
    sta $d8ac
    sta $d8ad
    sta $d8ae
    sta $d8af
    sta $d8b7
    sta $d8b8
    sta $d8b9
    sta $d8ba
    sta $d8bb
    sta $d8d0
    sta $d8d1
    sta $d8d2
    sta $d8d3
    sta $d8e3
    sta $d8e4
    sta $d8e5
    sta $d8e6
    sta $d8f7
    sta $d8f8
    sta $d8f9
    sta $d8fa
    sta $d90c
    sta $d90d
    sta $d90e
    sta $d90f
    sta $d91f
    sta $d920
    sta $d921
    sta $d922
    sta $d934
    sta $d935
    sta $d936
    sta $d937
    sta $d947
    sta $d948
    sta $d949
    sta $d94a
    sta $d95c
    sta $d95d
    sta $d95e
    sta $d95f
    sta $d96d
    sta $d96e
    sta $d96f
    sta $d987
    sta $d988
    sta $d989
    sta $d994
    sta $d995
    sta $d996
    sta $d9b0
    sta $d9b1
    sta $d9b2
    sta $d9bc
    sta $d9bd
    sta $d9be
    sta $d9d8
    sta $d9d9
    sta $d9da
    sta $d9e4
    sta $d9e5
    sta $d9e6
    sta $da00
    sta $da01
    sta $da02
    sta $da0c
    sta $da0d
    sta $da0e
    sta $da28
    sta $da29
    sta $da2a
    sta $da34
    sta $da35
    sta $da36
    sta $da50
    sta $da51
    sta $da52
    sta $da5d
    sta $da5e
    sta $da5f
    sta $da77
    sta $da78
    sta $da79
    sta $da87
    sta $da88
    sta $da89
    sta $da8a
    sta $da9c
    sta $da9d
    sta $da9e
    sta $da9f
    sta $daaf
    sta $dab0
    sta $dab1
    sta $dab2
    sta $dac4
    sta $dac5
    sta $dac6
    sta $dac7
    sta $dad7
    sta $dad8
    sta $dad9
    sta $dada
    sta $daec
    sta $daed
    sta $daee
    sta $daef
    sta $db00
    sta $db01
    sta $db02
    sta $db03
    sta $db13
    sta $db14
    sta $db15
    sta $db16
    sta $db2b
    sta $db2c
    sta $db2d
    sta $db2e
    sta $db2f
    sta $db37
    sta $db38
    sta $db39
    sta $db3a
    sta $db3b
    sta $db53
    sta $db54
    sta $db55
    sta $db56
    sta $db57
    sta $db5f
    sta $db60
    sta $db61
    sta $db62
    sta $db63
    sta $db7c
    sta $db7d
    sta $db7e
    sta $db7f
    sta $db80
    sta $db86
    sta $db87
    sta $db88
    sta $db89
    sta $db8a
    sta $dba8
    sta $dba9
    sta $dbaa
    sta $dbab
    sta $dbac
    sta $dbad
    sta $dbae
    sta $dbd1
    sta $dbd2
    sta $dbd3
    sta $dbd4
    sta $dbd5

    ;slice06
    inx
    lda ccycle04,x

    sta $d861
    sta $d862
    sta $d863
    sta $d864
    sta $d865
    sta $d888
    sta $d889
    sta $d88a
    sta $d88b
    sta $d88c
    sta $d88d
    sta $d88e
    sta $d8b0
    sta $d8b1
    sta $d8b2
    sta $d8b3
    sta $d8b4
    sta $d8b5
    sta $d8b6
    sta $d8d4
    sta $d8d5
    sta $d8d6
    sta $d8d7
    sta $d8d8
    sta $d8de
    sta $d8df
    sta $d8e0
    sta $d8e1
    sta $d8e2
    sta $d8fb
    sta $d8fc
    sta $d8fd
    sta $d8fe
    sta $d8ff
    sta $d907
    sta $d908
    sta $d909
    sta $d90a
    sta $d90b
    sta $d923
    sta $d924
    sta $d925
    sta $d926
    sta $d927
    sta $d92f
    sta $d930
    sta $d931
    sta $d932
    sta $d933
    sta $d94b
    sta $d94c
    sta $d94d
    sta $d94e
    sta $d94f
    sta $d957
    sta $d958
    sta $d959
    sta $d95a
    sta $d95b
    sta $d970
    sta $d971
    sta $d972
    sta $d973
    sta $d983
    sta $d984
    sta $d985
    sta $d986
    sta $d997
    sta $d998
    sta $d999
    sta $d99a
    sta $d9ac
    sta $d9ad
    sta $d9ae
    sta $d9af
    sta $d9bf
    sta $d9c0
    sta $d9c1
    sta $d9c2
    sta $d9d4
    sta $d9d5
    sta $d9d6
    sta $d9d7
    sta $d9e7
    sta $d9e8
    sta $d9e9
    sta $d9ea
    sta $d9fc
    sta $d9fd
    sta $d9fe
    sta $d9ff
    sta $da0f
    sta $da10
    sta $da11
    sta $da12
    sta $da24
    sta $da25
    sta $da26
    sta $da27
    sta $da37
    sta $da38
    sta $da39
    sta $da3a
    sta $da4c
    sta $da4d
    sta $da4e
    sta $da4f
    sta $da60
    sta $da61
    sta $da62
    sta $da63
    sta $da73
    sta $da74
    sta $da75
    sta $da76
    sta $da8b
    sta $da8c
    sta $da8d
    sta $da8e
    sta $da8f
    sta $da97
    sta $da98
    sta $da99
    sta $da9a
    sta $da9b
    sta $dab3
    sta $dab4
    sta $dab5
    sta $dab6
    sta $dab7
    sta $dabf
    sta $dac0
    sta $dac1
    sta $dac2
    sta $dac3
    sta $dadb
    sta $dadc
    sta $dadd
    sta $dade
    sta $dadf
    sta $dae7
    sta $dae8
    sta $dae9
    sta $daea
    sta $daeb
    sta $db04
    sta $db05
    sta $db06
    sta $db07
    sta $db08
    sta $db0e
    sta $db0f
    sta $db10
    sta $db11
    sta $db12
    sta $db30
    sta $db31
    sta $db32
    sta $db33
    sta $db34
    sta $db35
    sta $db36
    sta $db58
    sta $db59
    sta $db5a
    sta $db5b
    sta $db5c
    sta $db5d
    sta $db5e
    sta $db81
    sta $db82
    sta $db83
    sta $db84
    sta $db85

    ;slice07
    inx
    lda ccycle04,x

    sta $d8d9
    sta $d8da
    sta $d8db
    sta $d8dc
    sta $d8dd
    sta $d900
    sta $d901
    sta $d902
    sta $d903
    sta $d904
    sta $d905
    sta $d906
    sta $d928
    sta $d929
    sta $d92a
    sta $d92b
    sta $d92c
    sta $d92d
    sta $d92e
    sta $d950
    sta $d951
    sta $d952
    sta $d953
    sta $d954
    sta $d955
    sta $d956
    sta $d974
    sta $d975
    sta $d976
    sta $d977
    sta $d978
    sta $d97e
    sta $d97f
    sta $d980
    sta $d981
    sta $d982
    sta $d99b
    sta $d99c
    sta $d99d
    sta $d99e
    sta $d99f
    sta $d9a7
    sta $d9a8
    sta $d9a9
    sta $d9aa
    sta $d9ab
    sta $d9c3
    sta $d9c4
    sta $d9c5
    sta $d9c6
    sta $d9c7
    sta $d9cf
    sta $d9d0
    sta $d9d1
    sta $d9d2
    sta $d9d3
    sta $d9eb
    sta $d9ec
    sta $d9ed
    sta $d9ee
    sta $d9ef
    sta $d9f7
    sta $d9f8
    sta $d9f9
    sta $d9fa
    sta $d9fb
    sta $da13
    sta $da14
    sta $da15
    sta $da16
    sta $da17
    sta $da1f
    sta $da20
    sta $da21
    sta $da22
    sta $da23
    sta $da3b
    sta $da3c
    sta $da3d
    sta $da3e
    sta $da3f
    sta $da47
    sta $da48
    sta $da49
    sta $da4a
    sta $da4b
    sta $da64
    sta $da65
    sta $da66
    sta $da67
    sta $da68
    sta $da6e
    sta $da6f
    sta $da70
    sta $da71
    sta $da72
    sta $da90
    sta $da91
    sta $da92
    sta $da93
    sta $da94
    sta $da95
    sta $da96
    sta $dab8
    sta $dab9
    sta $daba
    sta $dabb
    sta $dabc
    sta $dabd
    sta $dabe
    sta $dae0
    sta $dae1
    sta $dae2
    sta $dae3
    sta $dae4
    sta $dae5
    sta $dae6
    sta $db09
    sta $db0a
    sta $db0b
    sta $db0c
    sta $db0d
    
    ;check gradient
    ldx colorframe
    cpx #$22
    bne contPattern04
    ldy patternCounter04
    iny
    sty patternCounter04
    ldx #$ff
contPattern04:
    inx 
    stx colorframe
    jsr singlewait
    rts

;;;;;;;;;;;;;;;;;
; PETSCII data

petscii_01:
!byte  32, 32, 32,108,255,108,247,236,108,247,160,208,108,247,160,247,123,108,247,160,247,123,108,247,160,247,123,207,160,247,123,251,247,123,127,123, 32, 32, 32, 32
!byte  32, 32,108,236, 32,228,226, 32,228,239,226,108,160,228,239,249,108,160,239,226,239,160,123,249,239,228,160,123,226,239,228, 32,226,228, 32,251,123, 32, 32, 32
!byte  32, 32,255,108,236,108,247,236,108,247,160,208,108,247,227,247,123,108,247,160,247,123,108,247,227,247,123,207,160,247,123,251,247,123,251,123,127, 32, 32, 32
!byte  32, 32,108,160,108,160,236,108,160,160,160,108,160,160,160,160,108,160,160,160,160,160,123,160,160,160,160,123,160,160,160,123,160,160,123,160,123, 32, 32, 32
!byte  32, 32,229,250,204,228,250,204,228,228,250,204,228,239,226,250,204,228,239,226,239,228,250,204,226,239,228,250,204,228,228,250,204,228,250,204,231, 32, 32, 32
!byte  32, 32,236,108,236,108,247,236,108,247,227,208,108,247,160,247,123,108,247,160,247,123,108,227,160,247,123,108,227,247,123,251,247,123,251,123,251, 32, 32, 32
!byte  32, 32,108,160,108,160,160,108,160,160,160,108,160,160,160,160,108,160,160,160,160,160,123,160,160,160,160,123,160,160,160,123,160,160,123,160,123, 32, 32, 32
!byte  32, 32,229,231,229,160,231,229,160,209,231,229,160,209,160,231,229,160,209,160,209,160,231,229,160,209,160,231,229,209,160,231,229,160,231,229,231, 32, 32, 32
!byte  32, 32,160, 97,239,228,126,239,228,239,126,239,228,239,226,126,160,160,239,226,239,160,160,124,226,239,228,239,124,239,228,239,124,228,239,225,160, 32, 32, 32
!byte  32, 32,236,108,236,108,247,236,108,247,160,208,108,247,160,247,123,108,247,160,247,123,108,247,160,247,123,207,160,247,123,251,247,123,251,123,251, 32, 32, 32
!byte  32, 32,108,160,108,160,160,108,160,160,160,108,160,160,160,160,108,213,196,242,196,201,123,160,160,160,160,123,160,160,160,123,160,160,123,160,123, 32, 32, 32
!byte  32, 32,229,231,229,160,231,229,160,209,231,229,160,209,160,231,229,225,209,160,209, 97,231,229,160,209,160,231,229,209,160,231,229,160,231,229,231, 32, 32, 32
!byte  32, 32,160, 97,160,160, 97,160,160,160, 97,160,160,160,160, 97,160,202,198,241,198,203,160,225,160,160,160,160,225,160,160,160,225,160,160,225,160, 32, 32, 32
!byte  32, 32,229,231,229,160,231,229,160,160,231,229,160,160,160,231,229,213,242,242,242,201,231,229,160,160,160,231,229,160,160,231,229,160,231,229,231, 32, 32, 32
!byte  32, 32,124,160,124,160,247,124,160,247,247,124,160,247,247,247,124,202,241,241,241,203,126,247,247,247,160,126,247,247,160,126,247,160,126,160,126, 32, 32, 32
!byte  32, 32,252,124,252,124,239,252,124,239,160,250,124,239,160,239,126,124,239,160,239,126,124,239,160,239,126,204,160,239,126,254,239,126,254,126,254, 32, 32, 32
!byte  32, 32,160, 97,247,227,123,247,227,247,123,247,227,247, 98,123,160,160,247, 98,247,160,160,108, 98,247,227,247,108,247,227,247,108,227,247,225,160, 32, 32, 32
!byte  32, 32,229,231,229,160,231,229,160,160,231,229,160,160,160,231,229,160,160,160,160,160,231,229,160,160,160,231,229,160,160,231,229,160,231,229,231, 32, 32, 32
!byte  32, 32,124,160,124,160,247,124,160,247,247,124,160,247,247,247,124,160,247,247,247,160,126,247,247,247,160,126,247,247,160,126,247,160,126,160,126, 32, 32, 32
!byte  32, 32,252,124,252,124,239,252,124,239,228,250,124,239,160,239,126,124,239,160,239,126,124,228,160,239,126,124,228,239,126,254,239,126,254,126,254, 32, 32, 32
!byte  32, 32,229,208,207,227,208,207,227,227,208,207,227,247, 98,208,207,227,247, 98,247,227,208,207, 98,247,227,208,207,227,227,208,207,227,208,207,231, 32, 32, 32
!byte  32, 32,124,160,124,160,247,124,160,247,247,124,160,247,247,247,124,160,247,247,247,160,126,247,247,247,160,126,247,247,160,126,247,160,126,160,126, 32, 32, 32
!byte  32, 32,127,124,252,124,239,252,124,239,160,250,124,239,228,239,126,124,239,160,239,126,124,239,228,239,126,204,160,239,126,254,239,126,254,126,255, 32, 32, 32
!byte  32, 32,124,252, 32,227, 98, 32,227,247, 98,124,160,227,247,248,124,160,247, 98,247,160,126,248,247,227,160,126, 98,247,227, 32, 98,227, 32,254,126, 32, 32, 32
!byte  32, 32, 32,124,127,124,239,252,124,239,160,250,124,239,160,239,126,124,239,160,239,126,124,239,160,239,126,204,160,239,126,254,239,126,255,126, 32, 32, 32, 32

;;;;;;;;;;;;;;;;;
; PETSCII color

color_01:
!byte   1,  1,  1,  6,  6,  4,  4,  4, 14, 14, 14, 14,  3,  3,  3,  3,  3, 13, 13, 13, 13, 13,  3,  3,  3,  3,  3, 14, 14, 14, 14,  4,  4,  4,  6,  6,  1,  1,  1,  1
!byte   1,  1,  6,  6,  1,  4,  4,  1, 14, 14, 14,  3,  3,  3,  3,  3, 13, 13, 13, 13, 13, 13, 13,  3,  3,  3,  3,  3, 14, 14, 14,  1,  4,  4,  1,  6,  6,  1,  1,  1
!byte   1,  1,  6,  6,  6,  4,  4,  4, 14, 14, 14, 14,  3,  3,  3,  3,  3, 13, 13, 13, 13, 13,  3,  3,  3,  3,  3, 14, 14, 14, 14,  4,  4,  4,  6,  6,  6,  1,  1,  1
!byte   1,  1,  6,  6,  4,  4,  4, 14, 14, 14, 14,  3,  3,  3,  3,  3, 13, 13, 13, 13, 13, 13, 13,  3,  3,  3,  3,  3, 14, 14, 14, 14,  4,  4,  4,  6,  6,  1,  1,  1
!byte   1,  1,  6,  6,  4,  4,  4, 14, 14, 14, 14,  3,  3,  3,  3,  3, 13, 13, 13, 13, 13, 13, 13,  3,  3,  3,  3,  3, 14, 14, 14, 14,  4,  4,  4,  6,  6,  1,  1,  1
!byte   1,  1,  6,  6,  6,  4,  4,  4, 14, 14, 14, 14,  3,  3,  3,  3,  3, 13, 13, 13, 13, 13,  3,  3,  3,  3,  3, 14, 14, 14, 14,  4,  4,  4,  6,  6,  6,  1,  1,  1
!byte   1,  1,  6,  6,  4,  4,  4, 14, 14, 14, 14,  3,  3,  3,  3,  3, 13, 13, 13, 13, 13, 13, 13,  3,  3,  3,  3,  3, 14, 14, 14, 14,  4,  4,  4,  6,  6,  1,  1,  1
!byte   1,  1,  6,  6,  4,  4,  4, 14, 14, 14, 14,  3,  3,  3,  3,  3, 13, 13, 13, 13, 13, 13, 13,  3,  3,  3,  3,  3, 14, 14, 14, 14,  4,  4,  4,  6,  6,  1,  1,  1
!byte   1,  1,  6,  6,  4,  4,  4, 14, 14, 14, 14,  3,  3,  3,  3,  3, 13, 13, 13, 13, 13, 13, 13,  3,  3,  3,  3,  3, 14, 14, 14, 14,  4,  4,  4,  6,  6,  1,  1,  1
!byte   1,  1,  6, 11, 11, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 15, 15,  1,  1,  1,  1,  1, 15, 15, 15, 15, 15, 12, 12, 12, 12, 12, 12, 12, 11, 11,  6,  1,  1,  1
!byte   1,  1, 11, 11, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 15, 15,  1,  1,  1,  1,  1,  1,  1, 15, 15, 15, 15, 15, 12, 12, 12, 12, 12, 12, 12, 11, 11,  1,  1,  1
!byte   1,  1, 11, 11, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 15, 15, 15,  1,  1,  1,  1,  1, 15, 15, 15, 15, 15, 15, 12, 12, 12, 12, 12, 12, 12, 11, 11,  1,  1,  1
!byte   1,  1, 11, 11, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 15, 15,  1,  1,  1,  1,  1,  1,  1, 15, 15, 15, 15, 15, 12, 12, 12, 12, 12, 12, 12, 11, 11,  1,  1,  1
!byte   1,  1, 11, 11, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 15, 15,  1,  1,  1,  1,  1,  1,  1, 15, 15, 15, 15, 15, 12, 12, 12, 12, 12, 12, 12, 11, 11,  1,  1,  1
!byte   1,  1, 11, 11, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 15, 15,  1,  1,  1,  1,  1,  1,  1, 15, 15, 15, 15, 15, 12, 12, 12, 12, 12, 12, 12, 11, 11,  1,  1,  1
!byte   1,  1,  2, 11, 11, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 15, 15,  1,  1,  1,  1,  1, 15, 15, 15, 15, 15, 12, 12, 12, 12, 12, 12, 12, 11, 11,  2,  1,  1,  1
!byte   1,  1,  2,  2,  9,  9,  9,  8,  8,  8,  8, 10, 10, 10, 10, 10,  7,  7,  7,  7,  7,  7,  7, 10, 10, 10, 10, 10,  8,  8,  8,  8,  9,  9,  9,  2,  2,  1,  1,  1
!byte   1,  1,  2,  2,  9,  9,  9,  8,  8,  8,  8, 10, 10, 10, 10, 10,  7,  7,  7,  7,  7,  7,  7, 10, 10, 10, 10, 10,  8,  8,  8,  8,  9,  9,  9,  2,  2,  1,  1,  1
!byte   1,  1,  2,  2,  9,  9,  9,  8,  8,  8,  8, 10, 10, 10, 10, 10,  7,  7,  7,  7,  7,  7,  7, 10, 10, 10, 10, 10,  8,  8,  8,  8,  9,  9,  9,  2,  2,  1,  1,  1
!byte   1,  1,  2,  2,  2,  9,  9,  9,  8,  8,  8,  8, 10, 10, 10, 10, 10,  7,  7,  7,  7,  7, 10, 10, 10, 10, 10,  8,  8,  8,  8,  9,  9,  9,  2,  2,  2,  1,  1,  1
!byte   1,  1,  2,  2,  9,  9,  9,  8,  8,  8,  8, 10, 10, 10, 10, 10,  7,  7,  7,  7,  7,  7,  7, 10, 10, 10, 10, 10,  8,  8,  8,  8,  9,  9,  9,  2,  2,  1,  1,  1
!byte   1,  1,  2,  2,  9,  9,  9,  8,  8,  8,  8, 10, 10, 10, 10, 10,  7,  7,  7,  7,  7,  7,  7, 10, 10, 10, 10, 10,  8,  8,  8,  8,  9,  9,  9,  2,  2,  1,  1,  1
!byte   1,  1,  2,  2,  2,  9,  9,  9,  8,  8,  8,  8, 10, 10, 10, 10, 10,  7,  7,  7,  7,  7, 10, 10, 10, 10, 10,  8,  8,  8,  8,  9,  9,  9,  2,  2,  2,  1,  1,  1
!byte   1,  1,  2,  2,  1,  9,  9,  1,  8,  8,  8, 10, 10, 10, 10, 10, 13,  7,  7,  7,  7,  7,  7, 10, 10, 10, 10, 10,  8,  8,  8,  1,  9,  9,  1,  2,  2,  1,  1,  1
!byte   1,  1,  1,  2,  2,  9,  9,  9,  8,  8,  8,  8, 10, 10, 10, 10, 10,  7,  7,  7,  7,  7, 10, 10, 10, 10, 10,  8,  8,  8,  8,  9,  9,  9,  2,  2,  1,  1,  1,  1

